#!/bin/bash

echo "================================"
echo "    BRA Chatbot Launcher"
echo "================================"
echo ""
echo "Starting Balochistan Revenue Authority Chatbot..."
echo ""

# Check if Python is installed
if ! command -v python3 &> /dev/null; then
    echo "❌ Python 3 is not installed. Please install Python 3.8+ and try again."
    exit 1
fi

# Check if pip is installed
if ! command -v pip3 &> /dev/null; then
    echo "❌ pip3 is not installed. Please install pip and try again."
    exit 1
fi

echo "✅ Python and pip found!"
echo ""

# Install dependencies
echo "📦 Installing dependencies..."
pip3 install -r requirements.txt

if [ $? -ne 0 ]; then
    echo "❌ Failed to install dependencies. Please check your internet connection and try again."
    exit 1
fi

echo ""
echo "✅ Dependencies installed successfully!"
echo ""

# Start the Flask server
echo "🚀 Starting Flask server..."
echo ""
echo "The chatbot will be available at:"
echo "🌐 http://localhost:5000"
echo ""
echo "Press Ctrl+C to stop the server"
echo "================================"
echo ""

python3 bra_chatbot.py
