#!/bin/bash

# Quick VPS Deployment Script for BRA Chatbot
# Run this script on your VPS server

echo "🚀 BRA Chatbot Quick Deployment Script"
echo "===================================="

# Get current user
USER=$(whoami)
echo "Deploying for user: $USER"

# Create directory
echo "📁 Creating directory..."
mkdir -p /home/$USER/bra_chatbot
cd /home/$USER/bra_chatbot

# Create virtual environment
echo "🐍 Setting up Python virtual environment..."
python3 -m venv bra_chatbot_env
source bra_chatbot_env/bin/activate

# Install dependencies
echo "📦 Installing Python dependencies..."
pip install -r requirements.txt

# Create systemd service
echo "⚙️ Creating systemd service..."
sudo tee /etc/systemd/system/bra_chatbot.service > /dev/null <<EOF
[Unit]
Description=BRA Chatbot
After=network.target

[Service]
User=$USER
WorkingDirectory=/home/$USER/bra_chatbot
Environment=PATH=/home/$USER/bra_chatbot/bra_chatbot_env/bin
ExecStart=/home/$USER/bra_chatbot/bra_chatbot_env/bin/gunicorn --bind 127.0.0.1:5000 bra_chatbot:app
Restart=always

[Install]
WantedBy=multi-user.target
EOF

# Create Nginx configuration
echo "🌐 Setting up Nginx..."
sudo tee /etc/nginx/sites-available/bra_chatbot > /dev/null <<EOF
server {
    listen 80;
    server_name _;

    location / {
        proxy_pass http://127.0.0.1:5000;
        proxy_set_header Host \$host;
        proxy_set_header X-Real-IP \$remote_addr;
        proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto \$scheme;
    }
}
EOF

# Enable site
sudo ln -sf /etc/nginx/sites-available/bra_chatbot /etc/nginx/sites-enabled/
sudo rm -f /etc/nginx/sites-enabled/default

# Test and restart services
echo "🔄 Starting services..."
sudo nginx -t
sudo systemctl restart nginx
sudo systemctl daemon-reload
sudo systemctl enable bra_chatbot
sudo systemctl start bra_chatbot

# Configure firewall
echo "🔥 Configuring firewall..."
sudo ufw allow 80
sudo ufw allow 443
sudo ufw --force enable

# Get server IP
SERVER_IP=$(curl -s ifconfig.me)

echo ""
echo "🎉 Deployment Complete!"
echo "======================"
echo "Your BRA chatbot is now live at:"
echo "http://$SERVER_IP"
echo ""
echo "To check status:"
echo "sudo systemctl status bra_chatbot"
echo ""
echo "To view logs:"
echo "sudo journalctl -u bra_chatbot -f"
echo ""
echo "To restart:"
echo "sudo systemctl restart bra_chatbot"
echo ""
