#!/usr/bin/env python3
"""
Passenger WSGI file for Hostinger deployment
This is the main entry point for the web server
"""

import sys
import os

# Add project directory to Python path
INTERP = "/usr/bin/python3"
if sys.executable != INTERP:
    os.execl(INTERP, INTERP, *sys.argv)

# Add current directory to path
sys.path.insert(0, os.getcwd())

# Import Flask application
from bra_chatbot import app as application

# For debugging (remove in production)
if __name__ == '__main__':
    application.run(debug=False)
