# 🚀 BRA Chatbot Deployment Guide for Hostinger

## 📋 Prerequisites

1. **Hostinger Account** with Python hosting support
2. **Domain name** (optional - can use subdomain)
3. **FTP/SFTP client** (FileZilla recommended)
4. **Your chatbot files** (ready to upload)

## 🌐 Step-by-Step Deployment Process

### **Step 1: Prepare Hostinger Hosting**

1. **Login to Hostinger hPanel**
   - Go to [hostinger.com](https://hostinger.com)
   - Login to your account
   - Access hPanel dashboard

2. **Choose Hosting Plan**
   - **Recommended:** Premium Shared Hosting or VPS
   - Ensure Python support is available
   - Check Python version (3.8+ recommended)

3. **Set up Domain**
   - Add your domain in hPanel
   - Or use provided subdomain (yoursite.hostinger-site.com)

### **Step 2: Enable Python Support**

1. **In hPanel, go to:**
   - Advanced → Python
   - Enable Python for your domain
   - Select Python 3.8 or higher

2. **Create Python App:**
   - App name: `bra_chatbot`
   - Python version: 3.8+
   - App root: `/public_html` (or subdirectory)
   - Startup file: `passenger_wsgi.py`

### **Step 3: Upload Files via FTP**

**Files to Upload:**
```
public_html/
├── passenger_wsgi.py          # Main WSGI file
├── bra_chatbot.py            # Your Flask app
├── requirements.txt          # Dependencies
├── .htaccess                 # Apache configuration
├── templates/
│   └── index.html           # HTML template
├── static/
│   ├── css/style.css        # Styles
│   ├── js/script.js         # JavaScript
│   └── assets/              # Download files
│       ├── BST-01_Registration_Form.txt
│       ├── BST-03_Return_Form.txt
│       └── BST-04_Payment_Challan.txt
```

**FTP Details:**
- **Host:** your-domain.com (or IP from hPanel)
- **Username:** Your hosting username
- **Password:** Your hosting password
- **Port:** 21 (FTP) or 22 (SFTP)

### **Step 4: Install Python Dependencies**

1. **Access Terminal in hPanel:**
   - Advanced → Terminal
   - Or use SSH if available

2. **Navigate to your app directory:**
   ```bash
   cd public_html
   ```

3. **Install dependencies:**
   ```bash
   pip3 install -r requirements.txt --user
   ```

### **Step 5: Configure Environment**

1. **Set Python Path:**
   - In hPanel → Python → Environment Variables
   - Add: `PYTHONPATH=/home/username/public_html`

2. **Update passenger_wsgi.py if needed:**
   - Ensure correct Python interpreter path
   - Verify Flask app import

### **Step 6: Test Deployment**

1. **Access your domain:**
   - https://your-domain.com
   - Or https://yoursite.hostinger-site.com

2. **Check functionality:**
   - Test chatbot responses
   - Verify download links work
   - Test all features

## 🔧 Alternative Deployment Methods

### **Method 1: Manual FTP Upload**

1. **Use FileZilla or similar FTP client**
2. **Upload all files to public_html directory**
3. **Set file permissions:**
   - Python files: 755
   - Static files: 644

### **Method 2: Git Integration**

1. **Create Git repository:**
   ```bash
   git init
   git add .
   git commit -m "Initial BRA chatbot deployment"
   ```

2. **Push to GitHub/GitLab**

3. **Clone on server:**
   ```bash
   git clone your-repo-url public_html
   ```

### **Method 3: ZIP Upload**

1. **Create ZIP of all files**
2. **Upload via hPanel File Manager**
3. **Extract in public_html directory**

## ⚙️ Configuration Tips

### **Python Version Issues:**
If Python 3.8+ not available:
- Contact Hostinger support
- Consider VPS hosting
- Update code for older Python versions

### **Import Errors:**
```python
# Add to top of passenger_wsgi.py
import sys
sys.path.insert(0, '/home/username/public_html')
```

### **Static Files Not Loading:**
```apache
# Add to .htaccess
<Directory "/home/username/public_html/static">
    Order allow,deny
    Allow from all
</Directory>
```

### **Database Setup (if needed later):**
1. **Create MySQL database in hPanel**
2. **Update connection string in Flask app**
3. **Import any required data**

## 🛡️ Security Considerations

### **Environment Variables:**
```python
# For sensitive data
import os
SECRET_KEY = os.environ.get('SECRET_KEY', 'your-secret-key')
```

### **HTTPS Setup:**
1. **Enable SSL in hPanel**
2. **Force HTTPS redirects**
3. **Update any hardcoded HTTP links**

### **Security Headers:**
Already included in .htaccess:
- X-Frame-Options
- X-Content-Type-Options
- X-XSS-Protection

## 📊 Monitoring & Maintenance

### **Error Logs:**
- Check hPanel → Error Logs
- Monitor Python application errors
- Set up email notifications

### **Performance:**
- Enable caching headers
- Compress static files
- Monitor resource usage

### **Updates:**
- Regular dependency updates
- Security patches
- Feature additions

## 🆘 Troubleshooting

### **Common Issues:**

1. **500 Internal Server Error:**
   - Check error logs
   - Verify Python path
   - Ensure all dependencies installed

2. **Import Module Errors:**
   - Check PYTHONPATH
   - Verify file permissions
   - Ensure all files uploaded

3. **Static Files 404:**
   - Check .htaccess configuration
   - Verify file paths in HTML
   - Ensure correct directory structure

4. **Database Connection Issues:**
   - Verify connection string
   - Check database credentials
   - Ensure database exists

### **Support Resources:**
- **Hostinger Documentation:** [hostinger.com/tutorials](https://hostinger.com/tutorials)
- **Hostinger Support:** Live chat available 24/7
- **Python/Flask Documentation:** Official docs

## 🎯 Go Live Checklist

- [ ] Domain configured
- [ ] Python environment set up
- [ ] All files uploaded
- [ ] Dependencies installed
- [ ] WSGI file configured
- [ ] Static files loading
- [ ] Chatbot responding
- [ ] Download links working
- [ ] SSL certificate active
- [ ] Error monitoring set up

## 🚀 Final Steps

1. **Test all functionality**
2. **Set up monitoring**
3. **Configure backups**
4. **Update DNS if needed**
5. **Announce your live chatbot!**

---

**🎉 Congratulations! Your BRA Chatbot is now live and serving users worldwide!**
