#!/bin/bash

echo "🚀 BRA Chatbot Deployment to Hostinger"
echo "======================================"

# Create deployment package
echo "📦 Creating deployment package..."

# Create a deployment directory
mkdir -p deployment_package

# Copy all necessary files
cp bra_chatbot.py deployment_package/
cp passenger_wsgi.py deployment_package/
cp wsgi.py deployment_package/
cp requirements.txt deployment_package/
cp .htaccess deployment_package/
cp -r templates deployment_package/
cp -r static deployment_package/

echo "✅ Files prepared for deployment!"
echo ""
echo "📋 Next Steps:"
echo "1. Login to your Hostinger hPanel"
echo "2. Go to Advanced → Python → Create Python App"
echo "3. Upload the 'deployment_package' folder contents to public_html"
echo "4. Install dependencies: pip3 install -r requirements.txt --user"
echo "5. Set startup file to: passenger_wsgi.py"
echo "6. Test your chatbot at your domain!"
echo ""
echo "📖 For detailed instructions, see: deployment_guide.md"
echo "🎉 Your BRA Chatbot will be live soon!"
