# 🚀 BRA Chatbot VPS Deployment Guide

## Prerequisites
- VPS server with Ubuntu/Debian
- SSH access to your VPS
- Domain name (optional but recommended)
- Basic knowledge of Linux commands

## Step-by-Step Deployment

### Step 1: Prepare Your Local Files

1. **Create a deployment folder on your local machine:**
   ```bash
   mkdir bra_chatbot_deployment
   cd bra_chatbot_deployment
   ```

2. **Copy all your BRA chatbot files to this folder:**
   - `bra_chatbot.py`
   - `requirements.txt`
   - `templates/` folder (with index.html)
   - `static/` folder (with css, js, assets)
   - `wsgi.py`
   - `passenger_wsgi.py`

### Step 2: Connect to Your VPS Server

1. **Open terminal/command prompt**
2. **Connect using SSH:**
   ```bash
   ssh username@your-server-ip
   ```
   Replace `username` with your VPS username and `your-server-ip` with your server IP address.

### Step 3: Install Required Software on VPS

1. **Update system packages:**
   ```bash
   sudo apt update && sudo apt upgrade -y
   ```

2. **Install Python 3 and pip:**
   ```bash
   sudo apt install python3 python3-pip python3-venv -y
   ```

3. **Install Nginx (web server):**
   ```bash
   sudo apt install nginx -y
   ```

4. **Install Gunicorn (WSGI server):**
   ```bash
   sudo apt install gunicorn -y
   ```

### Step 4: Upload Your Files to VPS

1. **Create a directory for your chatbot:**
   ```bash
   mkdir -p /home/username/bra_chatbot
   cd /home/username/bra_chatbot
   ```

2. **Upload your files using SCP (from your local machine):**
   ```bash
   scp -r /path/to/your/bra_chatbot/* username@your-server-ip:/home/username/bra_chatbot/
   ```

   **OR use SFTP:**
   ```bash
   sftp username@your-server-ip
   put -r /path/to/your/bra_chatbot/* /home/username/bra_chatbot/
   ```

### Step 5: Set Up Python Virtual Environment

1. **Navigate to your chatbot directory:**
   ```bash
   cd /home/username/bra_chatbot
   ```

2. **Create virtual environment:**
   ```bash
   python3 -m venv bra_chatbot_env
   ```

3. **Activate virtual environment:**
   ```bash
   source bra_chatbot_env/bin/activate
   ```

4. **Install Python dependencies:**
   ```bash
   pip install -r requirements.txt
   ```

### Step 6: Configure Nginx

1. **Create Nginx configuration file:**
   ```bash
   sudo nano /etc/nginx/sites-available/bra_chatbot
   ```

2. **Add the following configuration:**
   ```nginx
   server {
       listen 80;
       server_name your-domain.com www.your-domain.com;

       location / {
           proxy_pass http://127.0.0.1:5000;
           proxy_set_header Host $host;
           proxy_set_header X-Real-IP $remote_addr;
           proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
           proxy_set_header X-Forwarded-Proto $scheme;
       }
   }
   ```

3. **Enable the site:**
   ```bash
   sudo ln -s /etc/nginx/sites-available/bra_chatbot /etc/nginx/sites-enabled/
   ```

4. **Test Nginx configuration:**
   ```bash
   sudo nginx -t
   ```

5. **Restart Nginx:**
   ```bash
   sudo systemctl restart nginx
   ```

### Step 7: Create Systemd Service

1. **Create service file:**
   ```bash
   sudo nano /etc/systemd/system/bra_chatbot.service
   ```

2. **Add the following content:**
   ```ini
   [Unit]
   Description=BRA Chatbot
   After=network.target

   [Service]
   User=username
   WorkingDirectory=/home/username/bra_chatbot
   Environment=PATH=/home/username/bra_chatbot/bra_chatbot_env/bin
   ExecStart=/home/username/bra_chatbot/bra_chatbot_env/bin/gunicorn --bind 127.0.0.1:5000 bra_chatbot:app
   Restart=always

   [Install]
   WantedBy=multi-user.target
   ```

3. **Enable and start the service:**
   ```bash
   sudo systemctl daemon-reload
   sudo systemctl enable bra_chatbot
   sudo systemctl start bra_chatbot
   ```

### Step 8: Configure Firewall

1. **Allow HTTP traffic:**
   ```bash
   sudo ufw allow 80
   sudo ufw allow 443
   ```

2. **Enable firewall:**
   ```bash
   sudo ufw enable
   ```

### Step 9: Test Your Deployment

1. **Check if your chatbot is running:**
   ```bash
   sudo systemctl status bra_chatbot
   ```

2. **Check Nginx status:**
   ```bash
   sudo systemctl status nginx
   ```

3. **Test your chatbot:**
   Open your browser and go to: `http://your-server-ip`

### Step 10: Optional - Set Up SSL Certificate (for HTTPS)

1. **Install Certbot:**
   ```bash
   sudo apt install certbot python3-certbot-nginx -y
   ```

2. **Get SSL certificate:**
   ```bash
   sudo certbot --nginx -d your-domain.com -d www.your-domain.com
   ```

## 🎉 Your BRA Chatbot is Now Live!

- **Access it at:** `http://your-server-ip` or `https://your-domain.com`
- **For support, check the logs:** `sudo journalctl -u bra_chatbot -f`

## Troubleshooting

### Common Issues:

1. **Permission denied errors:**
   ```bash
   sudo chown -R username:username /home/username/bra_chatbot
   ```

2. **Service not starting:**
   ```bash
   sudo journalctl -u bra_chatbot -f
   ```

3. **Nginx not working:**
   ```bash
   sudo nginx -t
   sudo systemctl restart nginx
   ```

4. **Port already in use:**
   ```bash
   sudo netstat -tlnp | grep :5000
   sudo kill -9 <PID>
   ```

## File Structure on VPS:
```
/home/username/bra_chatbot/
├── bra_chatbot.py
├── requirements.txt
├── wsgi.py
├── passenger_wsgi.py
├── templates/
│   └── index.html
├── static/
│   ├── css/
│   │   └── style.css
│   ├── js/
│   │   └── script.js
│   └── assets/
│       ├── BST-01_Registration_Form.txt
│       ├── BST-03_Return_Form.txt
│       └── BST-04_Payment_Challan.txt
└── bra_chatbot_env/
    └── (virtual environment files)
```

## Security Recommendations:

1. **Change default SSH port**
2. **Use SSH keys instead of passwords**
3. **Keep system updated**
4. **Use strong passwords**
5. **Enable firewall**
6. **Use HTTPS with SSL certificate**

Your BRA chatbot should now be successfully deployed and accessible from anywhere on the internet! 🌐
